/*


lc


*/


function SwipeCarousel(options){


	var tid=0,tidx=0,changeFn;


	var myScroll=window.myScroll;


	var swipeEnable=true;


	var opt={


		wraper:'',//最外部元素id选择器或元素


		scroller:'.sc_scroller',//滚动部分选择器 默认.sc_scroller


		item:'li',//显示项项选择器
		navs:'',//导航选择器
		delay:0,//切换延时 0为不自动播放


		loop:false,//循环播放 无缝


		swipe:true,//手势滑动


		itemWidth:320,


		autoWidth:false//宽度自动,会改变容器及item的宽度为屏幕宽度,并在resize时自动刷新控件,以适应
	}


	$.extend(opt,options);


	var w,endOffset,start,end,sWidth,wraper,scroller,items,navs;


	var posX=0,sx,x,sTop;


	var sc_resize=function(){


				var clearHandle;


				return function(){


					clearTimeout(clearHandle)


					clearHandle=setTimeout(function(){refresh();},200);


				}


	}()


	init();


	function init(){


		changeFn=opt.onChange;


		wraper=$(opt.wraper);


		scroller=wraper.find(opt.scroller);


		items=wraper.find(opt.item);


		navs=$(opt.navs);


		if(opt.autoWidth){


			var tw=$(window).width();


			tw=tw>640?640:tw;


			w=tw;


			wraper.width(tw);


			$(window).off('resize',sc_resize).on('resize',sc_resize);


		}else{


			w=opt.itemWidth;


		}


		items.css({'width':w+'px'});


		endOffset=wraper.width()==0?0:Math.round(wraper.width()/w)-1;//隐藏时
		start=0,end=items.length-endOffset;


		sWidth=opt.scrollerWidth||w*items.length;


		scroller.css('width',sWidth);


		if(opt.loop){


			scroller.append(items.eq(0).clone().addClass('sc_clone'));


			scroller.css({'width':w*(items.length+1)});


			if(window.lazyLoad){//延迟加载更新


				window.lazyLoad.setting();


			}


		}


		if(opt.swipe){


			scroller.on('touchstart',sc_tStart);


			scroller.on('touchmove',sc_tMove);


			scroller.on('touchend',sc_tEnd);


		}


	}


	function sc_tStart(e){


				if(!swipeEnable)return;


				clearTimeout(tid);


				if(myScroll){


					sTop=myScroll.y;


				}


				e.preventDefault();


				sx=posX=x=e.targetTouches[0].pageX;


	}


	function sc_tMove(e){


				if(!swipeEnable)return;


				if(myScroll){


					if(Math.abs(myScroll.y-sTop)>5)return;


				}


				e.preventDefault();


				x=e.targetTouches[0].pageX;


				var offset=posX-x;


				//第一张左滚动时切到faker的位置
				if(opt.loop&&tidx==0&&offset<0){


					scroller.css({'-webkit-transform':'translate('+(-w*end)+'px,0px) translateZ(0px)'});


					tidx=end;


				}


				posX=x;


				var mleft=scroller.css('-webkit-transform')!='none'?Number(scroller.css('-webkit-transform').match(/translate\((.*?)px,.*?\)/i)[1]):0;


				scroller.css({'-webkit-transform':'translate('+(mleft-offset)+'px,0px) translateZ(0px)'});


	}


	function sc_tEnd(e){


				if(!swipeEnable)return;


				if(myScroll){


					if(Math.abs(myScroll.y-sTop)>5){


						swipeLeft(true,tidx);


						return;


					}


				}


				e.preventDefault();


				var cs=Math.abs(sx-x);


				if(cs>w/5){


					//多个块滑动计算
					var s=Math.ceil(cs/w);


					sx-x>0?swipeLeft(true,tidx+s):swipeRight(true,tidx-s);


					//sx-x>0?swipeLeft(true):swipeRight(true);


				}else if( cs >= 3){


					swipeLeft(true,tidx);


				}


	}


	function destroy(isRefresh){


		if(opt.loop){


			scroller.find('.sc_clone').remove();


			scroller.css({'width':''});


		}


		if(opt.swipe){


			scroller.off('touchstart',sc_tStart);


			scroller.off('touchmove',sc_tMove);


			scroller.off('touchend',sc_tEnd);


		}


		scroller.css({'-webkit-transform':''});


		if(opt.autoWidth&&!isRefresh){


			$(window).off(sc_resize);


		}


	}


	function refresh(options){


		destroy(true);


		$.extend(opt,options);


		init();


	}


	function swipeLeft(isTouch,step){


		isTouch=!!isTouch;


		if(step!=null){


			tidx=step;


		}else{


			tidx++;


		}


		if(tidx>=end&&!opt.loop){


			tidx=end-1;


		}


		if(navs.length>0){


			navs.removeClass('active');


			navs.eq(tidx==end?start:tidx).addClass('active');


		}


		scroller.animate({'-webkit-transform':'translate('+(-w*tidx)+'px,0px) translateZ(0px)'},200,'linear',function(){


			if(opt.loop&&tidx>=end){


				scroller.css({'-webkit-transform':'translate('+(-w*start)+'px,0px) translateZ(0px)'});


				tidx=start;


			}


		});


		if(scroller.width()==0){


			if(opt.loop&&tidx>=end){


				scroller.css({'-webkit-transform':'translate('+(-w*start)+'px,0px) translateZ(0px)'});


				tidx=start;


			}


		}


		onchange(isTouch);


		autoplay();


	}


	function swipeRight(isTouch,step){


		isTouch=!!isTouch;


		if(step!=null){


			tidx=step;


		}else{


			tidx--;


		}


		if(tidx<start){


			if(opt.loop){


				scroller.css({'-webkit-transform':'translate('+(-w*end)+'px,0px) translateZ(0px)'});


				tidx=end-1;


			}else{


				tidx=start;


			}


		}


		if(navs.length>0){


			navs.removeClass('active');


			navs.eq(tidx).addClass('active');


		}


		scroller.animate({'-webkit-transform':'translate('+(-w*tidx)+'px,0px) translateZ(0px)'},200,'linear');


		onchange(isTouch);


		autoplay();


	}


	function autoplay(){


		if(opt.delay!=0){


			clearTimeout(tid);


			tid=setTimeout(swipeLeft,opt.delay);


		}


	};


	autoplay();


	


	function getIndex(){


		return tidx+1>end?1:tidx+1;


	}


	function onchange(isTouch){


		if(changeFn)changeFn(getIndex(),isTouch);


	}


	this.onChange=function(fn){


		if(fn)opt.onChange=changeFn=fn;


	}


	this.setSwipeEnable=function(v){


		swipeEnable=v;


	}


	this.prev=swipeRight;


	this.next=swipeLeft;


	this.getIndex=getIndex;


	this.refresh=refresh;


	this.destroy=destroy;


}